# vectorUtils.R

# Concatenates the vector using commas between the elements
vectorToString <- function(vec, last.and = FALSE) {
  if (last.and & length(vec) > 1) {
    # Concatenate all elements except the last one using commas
    str.commas <- paste(vec[-length(vec)], collapse = ", ")
    # Concatenate the last element using "and"
    str.and <- paste(str.commas, "and", vec[length(vec)])
    return(str.and)
  } else
    # Concatenate all elements using commas
    return(paste(vec, collapse = ", "))
}
