# parseArgs.R

checkArgs <- function(args) {
  # Discard arguments # 3,4,...
  args.copy <- args[1:2]
  # Check whether the second argument is a number
  # as.numerics produces NA with the warning if it cannot convert
  # suppress the warning about NA
  if (suppressWarnings(is.na(as.numeric(args.copy[2]))))
    args.copy <- args[1] # Discard the second argument
  return(args.copy)
}

parseArgs <- function(args, cars) {
  # Store the first argument in a separate variable
  car.make <- args[1]

  # Select the entries with the specified car make
  cars.make.data <- cars[cars$Make == car.make, ]

  if (length(args) == 1) {
    return(cars.make.data)
  }

  if (length(args) == 2) {
    # Convert the second argument to numeric value and store in a variable
    car.year <- as.numeric(args[2])

    # Select the entries that are of the specified make and year
    cars.by.make.and.year <- cars.make.data[cars.make.data$Year == car.year, ]

    return(cars.by.make.and.year)
  } 
}
