# car_search.R

# args[1] must be a car make
# args[2] must be a year of a car model (if specified)
args <- commandArgs(trailingOnly = TRUE)

# import function vectorToString
source("lib/vectorUtils.R")

# import function checkArgs and parseArgs
source("lib/parseArgs.R")

# import function displayModels
source("lib/displayCars.R")

# Stop the script if no arguments were specified
if (length(args) == 0) {

  cat("usage: Rscript car_search.R make\n")
  quit()

} 

# Make sure arguments are accurate
args.filtered <- checkArgs(args)

# Read the dataset
cars <- read.csv("./data/cars.csv")

# Slice the data frame using the arguments
selected.cars <- parseArgs(args.filtered, cars)

# View the resulting data frame
displayModels(selected.cars)
