import sqlite3
from numpy import linspace
import subprocess

db = sqlite3.connect("ljproject.sqlite3")

sql = "SELECT lower_limit, upper_limit FROM parameters WHERE name='temperature'"
selection = db.execute(sql)
T_lower_limit, T_upper_limit = selection.fetchone()

numpoints = 10
temperature_array = linspace(T_lower_limit, T_upper_limit, numpoints)

sql = "SELECT lower_limit, upper_limit FROM parameters WHERE name='density'"
selection = db.execute(sql)
d_lower_limit, d_upper_limit = selection.fetchone()
density_array = linspace(d_lower_limit, d_upper_limit, numpoints)

N = db.execute("SELECT lower_limit FROM parameters WHERE name='number'").fetchone()[0]

seed = db.execute("SELECT lower_limit FROM parameters WHERE name='seed'").fetchone()[0]

runtime = db.execute("SELECT lower_limit FROM parameters WHERE name='runtime'").fetchone()[0]

timestep = db.execute("SELECT lower_limit FROM parameters WHERE name='timestep'").fetchone()[0]

equil = db.execute("SELECT lower_limit FROM parameters WHERE name='equil'").fetchone()[0]

trajectory = 1
trajectorychar = ["F","T"]

db.execute("CREATE TABLE IF NOT EXISTS parameter_sets (  \
              Seq              INTEGER PRIMARY KEY, \
              temperature      REAL,                \
              density          REAL,                \
              number           INTEGER,             \
              runtime          REAL,                \
              timestep         REAL,                \
              seed             INTEGER,             \
              equil           REAL,                \
              trajectory       INTEGER              \
           )")

settings = [(T, d, N, runtime, timestep, seed, equil, trajectory) for T in temperature_array for d in density_array]
db.executemany("INSERT INTO parameter_sets VALUES (NULL,?,?,?,?,?,?,?,?)", settings)
db.commit()
db.close()

# let gnu parallel setup its own structure for keeping job records
gnu_parallel_prepare_command = " ".join(["parallel",
                                         "--sqlmaster", "sqlite3:///ljproject.sqlite3/jobs",
                                         "./lj",
                                         "{#}",
                                         "Ar",
                                         "{1}",
                                         "{2}",
                                         "{3}",
                                         "{4}",
                                         "{5}",
                                         "{6}",
                                         "{7}",
                                         "{8}",
                                         "::: " + " ".join(map(str,temperature_array)),
                                         "::: " + " ".join(map(str,density_array)),
                                         "::: " + str(N),
                                         "::: " + str(runtime),
                                         "::: " + str(timestep),
                                         "::: " + str(seed),
                                         "::: " + str(equil),
                                         "::: " + trajectorychar[trajectory]])
gnu_parallel_runjobs_command = " ".join(["parallel",
                                         "-j", "$SLURM_TASKS_PER_NODE",
                                         "--sqlworker", 
                                         "sqlite3:///ljproject.sqlite3/jobs"])
subprocess.Popen(gnu_parallel_prepare_command, shell=True).wait()

f=open("C_runjobs.sh","w")
f.write("""#!/bin/bash
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=16
#SBATCH --time 1:00:00
#SBATCH --job-name C_runjobs
#SBATCH --output %x_%j.out

source setup

""" + gnu_parallel_runjobs_command +
"""
""")
f.close()
