import sqlite3
import json

db = sqlite3.connect("ljproject.sqlite3")

db.execute("CREATE TABLE IF NOT EXISTS measurements ( \
              Seq              INTEGER UNIQUE,        \
              substance        TEXT,                  \
              total_energy     REAL,                  \
              potential_energy REAL,                  \
              kinetic_energy   REAL,                  \
              temperature      REAL,                  \
              pressure         REAL                   \
           )")

result_array = []

sql = "SELECT Seq from jobs"
for Seq, in db.execute(sql).fetchall():
    with open(str(Seq) + "/report.json") as f:
        data = json.load(f)
    result_array.append([Seq,
                         data["parameters"]["substance"],
                         data["measurements"]["energy"]["total"]["value"],
                         data["measurements"]["energy"]["potential"]["value"],
                         data["measurements"]["energy"]["kinetic"]["value"],
                         data["measurements"]["temperature"]["value"],
                         data["measurements"]["pressure"]["value"]])

db.executemany("INSERT INTO measurements VALUES (?,?,?,?,?,?,?)", result_array)
db.commit()
db.close()
