
# MyMenus.py
from Tkinter import Menu, Frame


class MyMenus(Frame):

    def __init__(self, master = None):

        Frame.__init__(self, master)
        self.pack()

        self.master.minsize(100,100)

        # Create a menu instance, the menu does not need packing.
        self.mbar = Menu(self)

        # Attach to the root menu.
        self.master.config(menu = self.mbar)

        # Create a new menu instance...
        self.filemenu = Menu(self.mbar, tearoff = 0)

        # ...and stick into the menubar.
        self.mbar.add_cascade(label = "File", menu = self.filemenu)

        # Add entries to the filemenu.
        self.filemenu.add_command(label = "New", command = self.new_call)
        self.filemenu.add_command(label = "Open", command = self.o_call)
        

    # The callback functions.
    def new_call(self):
        print "called new_call"

    def o_call(self):
        print "called o_call"


if __name__ == "__main__": 
    MyMenus().mainloop()
