
# switchface.py
from Tkinter import Button, Frame
from PIL.Image import open
from PIL.ImageTk import PhotoImage

class switchface(Frame):

    def __init__(self, master = None):

        Frame.__init__(self, master)
        self.pack()

        # The pic currently displayed.
        self.current = 0

        # Open the images.
        self.img0 = open("Happy.jpg")
        self.img1 = open("Sad.jpg")

        # Make them tkinter-compatible.
        self.pic0 = PhotoImage(self.img0)
        self.pic1 = PhotoImage(self.img1)

        # Create button, add image.
        self.b = Button(self, image = self.pic0,
                   command = self.switch)
        self.b.pack()

        # Keep a reference (not necessary, for some reason).
        self.b.image = self.pic0


    def switch(self):
        if (self.current == 0):
            self.b.configure(image = self.pic1)
            self.current = 1
        else:
            self.b.configure(image = self.pic0)
            self.current = 0


if __name__ == "__main__": switchface().mainloop()
