
# MyCheckbutton.py
from Tkinter import IntVar, Checkbutton, Frame, BOTH


class MyCheckbutton(Frame):

    def __init__(self, master = None):

        Frame.__init__(self, master)
        self.pack(expand = True, fill = BOTH)

        self.master.title("")
        self.master.minsize(200, 100)

        # Object variables.
        self.var = IntVar()

        # Create a checkbutton.
        cb = Checkbutton(self, text = "Show title",
                         variable = self.var,
                         command = self.click)

        cb.place(x = 50, y = 50)


    # Callback function
    def click(self):
        if (self.var.get() == 1):
            self.master.title("Checkbutton")
        else:
            self.master.title("")


if __name__ == "__main__": 
    MyCheckbutton().mainloop()
