# plotdens.py 
# Ramses van Zon
# SciNetHPC, 2016
#
_plotdens_vmin = -10.0
_plotdens_vmax = 10.0
_plotdens_image_number = 1
def plotdens(dens,x1,x2,first=False):
    '''plot a 2d density, using matplotlib's imshow. The density should be
    in a square array "dens", with x and y values ranging from x1 to
    x2 and density values plotted with a colormap as if they range
    from d1 to d2. "first" should be set to True upon first call,
    which will clear the figure and add the colorbar.
    '''
    import matplotlib.pyplot as plt
    global _plotdens_vmin
    global _plotdens_vmax
    global _plotdens_image_number
    if first:
        _plotdens_image_number = 1
        _plotdens_vmin = min(min(d) for d in dens)
        _plotdens_vmax = 1.#max(max(d) for d in dens)
    if first:
        plt.clf()
        plt.ion()
    plt.imshow(dens,interpolation='none',aspect='equal',extent=(x1,x2,x1,x2),vmin=_plotdens_vmin,vmax=_plotdens_vmax,cmap='nipy_spectral')
    if first:
        plt.colorbar()
    plt.show()
    plt.pause(0.1)
    #plt.savefig("image"+str(_plotdens_image_number)+".png")
    _plotdens_image_number += 1

